<?php

namespace Give\Helpers;

/**
 * This class use to register script.
 * This class internally uses asset information to set script dependencies and version generated by @wordpress/dependency-extraction-webpack-plugin package.
 * It also handles script translation registration.
 *
 * @since 2.19.6
 */
class EnqueueScript
{
    /**
     * @since 2.19.6
     *
     * @param string $scriptId
     * @param string $scriptPath
     *
     * @return \Give\Framework\EnqueueScript
     */
    public static function make($scriptId, $scriptPath)
    {
        return new \Give\Framework\EnqueueScript(
            $scriptId,
            $scriptPath,
            GIVE_PLUGIN_DIR,
            GIVE_PLUGIN_URL,
            'give'
        );
    }
}
