<?php
/**
 * WorkspaceOptionsUpdateRequest
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  cnb\api
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * CallNowButton API
 *
 * API for CallNowButton. Includes auth, domains, buttons/actions/conditions, but also chat and admin features.
 *
 * The version of the OpenAPI document: 0.0.219-local
 * Contact: support@nowbuttons.com
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.12.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace cnb\api\Model;

use \ArrayAccess;
use \cnb\api\ObjectSerializer;

/**
 * WorkspaceOptionsUpdateRequest Class Doc Comment
 *
 * @category Class
 * @package  cnb\api
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class WorkspaceOptionsUpdateRequest implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'WorkspaceOptionsUpdateRequest';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'default_assignees' => 'string[]',
        'default_email_notification' => 'string[]',
        'default_email_delay' => 'int',
        'default_inactivity_limit' => 'int',
        'email_clients_about_unread_messages' => 'bool'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'default_assignees' => null,
        'default_email_notification' => null,
        'default_email_delay' => 'int32',
        'default_inactivity_limit' => 'int64',
        'email_clients_about_unread_messages' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'default_assignees' => false,
        'default_email_notification' => false,
        'default_email_delay' => false,
        'default_inactivity_limit' => false,
        'email_clients_about_unread_messages' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'default_assignees' => 'defaultAssignees',
        'default_email_notification' => 'defaultEmailNotification',
        'default_email_delay' => 'defaultEmailDelay',
        'default_inactivity_limit' => 'defaultInactivityLimit',
        'email_clients_about_unread_messages' => 'emailClientsAboutUnreadMessages'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'default_assignees' => 'setDefaultAssignees',
        'default_email_notification' => 'setDefaultEmailNotification',
        'default_email_delay' => 'setDefaultEmailDelay',
        'default_inactivity_limit' => 'setDefaultInactivityLimit',
        'email_clients_about_unread_messages' => 'setEmailClientsAboutUnreadMessages'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'default_assignees' => 'getDefaultAssignees',
        'default_email_notification' => 'getDefaultEmailNotification',
        'default_email_delay' => 'getDefaultEmailDelay',
        'default_inactivity_limit' => 'getDefaultInactivityLimit',
        'email_clients_about_unread_messages' => 'getEmailClientsAboutUnreadMessages'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('default_assignees', $data ?? [], null);
        $this->setIfExists('default_email_notification', $data ?? [], null);
        $this->setIfExists('default_email_delay', $data ?? [], null);
        $this->setIfExists('default_inactivity_limit', $data ?? [], null);
        $this->setIfExists('email_clients_about_unread_messages', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['default_assignees'] === null) {
            $invalidProperties[] = "'default_assignees' can't be null";
        }
        if ($this->container['default_email_notification'] === null) {
            $invalidProperties[] = "'default_email_notification' can't be null";
        }
        if ($this->container['default_email_delay'] === null) {
            $invalidProperties[] = "'default_email_delay' can't be null";
        }
        if (($this->container['default_email_delay'] < -1)) {
            $invalidProperties[] = "invalid value for 'default_email_delay', must be bigger than or equal to -1.";
        }

        if ($this->container['default_inactivity_limit'] === null) {
            $invalidProperties[] = "'default_inactivity_limit' can't be null";
        }
        if (($this->container['default_inactivity_limit'] < -1)) {
            $invalidProperties[] = "invalid value for 'default_inactivity_limit', must be bigger than or equal to -1.";
        }

        if ($this->container['email_clients_about_unread_messages'] === null) {
            $invalidProperties[] = "'email_clients_about_unread_messages' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets default_assignees
     *
     * @return string[]
     */
    public function getDefaultAssignees()
    {
        return $this->container['default_assignees'];
    }

    /**
     * Sets default_assignees
     *
     * @param string[] $default_assignees These are Persona IDs.
     *
     * @return self
     */
    public function setDefaultAssignees($default_assignees)
    {
        if (is_null($default_assignees)) {
            throw new \InvalidArgumentException('non-nullable default_assignees cannot be null');
        }
        $this->container['default_assignees'] = $default_assignees;

        return $this;
    }

    /**
     * Gets default_email_notification
     *
     * @return string[]
     */
    public function getDefaultEmailNotification()
    {
        return $this->container['default_email_notification'];
    }

    /**
     * Sets default_email_notification
     *
     * @param string[] $default_email_notification These are IDs of WorkspaceMembers.
     *
     * @return self
     */
    public function setDefaultEmailNotification($default_email_notification)
    {
        if (is_null($default_email_notification)) {
            throw new \InvalidArgumentException('non-nullable default_email_notification cannot be null');
        }
        $this->container['default_email_notification'] = $default_email_notification;

        return $this;
    }

    /**
     * Gets default_email_delay
     *
     * @return int
     */
    public function getDefaultEmailDelay()
    {
        return $this->container['default_email_delay'];
    }

    /**
     * Sets default_email_delay
     *
     * @param int $default_email_delay After how many minutes to send an email notification about a new chat message.
     *
     * @return self
     */
    public function setDefaultEmailDelay($default_email_delay)
    {
        if (is_null($default_email_delay)) {
            throw new \InvalidArgumentException('non-nullable default_email_delay cannot be null');
        }

        if (($default_email_delay < -1)) {
            throw new \InvalidArgumentException('invalid value for $default_email_delay when calling WorkspaceOptionsUpdateRequest., must be bigger than or equal to -1.');
        }

        $this->container['default_email_delay'] = $default_email_delay;

        return $this;
    }

    /**
     * Gets default_inactivity_limit
     *
     * @return int
     */
    public function getDefaultInactivityLimit()
    {
        return $this->container['default_inactivity_limit'];
    }

    /**
     * Sets default_inactivity_limit
     *
     * @param int $default_inactivity_limit The default inactivity limit in minutes.
     *
     * @return self
     */
    public function setDefaultInactivityLimit($default_inactivity_limit)
    {
        if (is_null($default_inactivity_limit)) {
            throw new \InvalidArgumentException('non-nullable default_inactivity_limit cannot be null');
        }

        if (($default_inactivity_limit < -1)) {
            throw new \InvalidArgumentException('invalid value for $default_inactivity_limit when calling WorkspaceOptionsUpdateRequest., must be bigger than or equal to -1.');
        }

        $this->container['default_inactivity_limit'] = $default_inactivity_limit;

        return $this;
    }

    /**
     * Gets email_clients_about_unread_messages
     *
     * @return bool
     */
    public function getEmailClientsAboutUnreadMessages()
    {
        return $this->container['email_clients_about_unread_messages'];
    }

    /**
     * Sets email_clients_about_unread_messages
     *
     * @param bool $email_clients_about_unread_messages Whether to send an email to the client about unread messages.
     *
     * @return self
     */
    public function setEmailClientsAboutUnreadMessages($email_clients_about_unread_messages)
    {
        if (is_null($email_clients_about_unread_messages)) {
            throw new \InvalidArgumentException('non-nullable email_clients_about_unread_messages cannot be null');
        }
        $this->container['email_clients_about_unread_messages'] = $email_clients_about_unread_messages;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


