<?php
/**
 * WordPressInfo
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  cnb\api
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * CallNowButton API
 *
 * API for CallNowButton. Includes auth, domains, buttons/actions/conditions, but also chat and admin features.
 *
 * The version of the OpenAPI document: 0.0.219-local
 * Contact: support@nowbuttons.com
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.12.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace cnb\api\Model;

use \ArrayAccess;
use \cnb\api\ObjectSerializer;

/**
 * WordPressInfo Class Doc Comment
 *
 * @category Class
 * @package  cnb\api
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class WordPressInfo implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'WordPressInfo';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'current_domain' => '\cnb\api\Model\Domain',
        'workspace' => '\cnb\api\Model\Workspace',
        'domains' => '\cnb\api\Model\Domain[]',
        'buttons' => '\cnb\api\Model\Button[]',
        'validation_messages' => '\cnb\api\Model\ValidationResult[]',
        'user' => '\cnb\api\Model\User',
        'coupon' => '\cnb\api\Model\PromotionCode',
        'plans' => '\cnb\api\Model\StripePlan[]',
        'agency_plans' => '\cnb\api\Model\StripeAgencyPlan[]',
        'subscription_status_data' => '\cnb\api\Model\SubscriptionStatusData',
        'settings' => '\cnb\api\Model\SettingsOptions'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'current_domain' => null,
        'workspace' => null,
        'domains' => null,
        'buttons' => null,
        'validation_messages' => null,
        'user' => null,
        'coupon' => null,
        'plans' => null,
        'agency_plans' => null,
        'subscription_status_data' => null,
        'settings' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'current_domain' => false,
        'workspace' => false,
        'domains' => false,
        'buttons' => false,
        'validation_messages' => false,
        'user' => false,
        'coupon' => false,
        'plans' => false,
        'agency_plans' => false,
        'subscription_status_data' => false,
        'settings' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'current_domain' => 'currentDomain',
        'workspace' => 'workspace',
        'domains' => 'domains',
        'buttons' => 'buttons',
        'validation_messages' => 'validationMessages',
        'user' => 'user',
        'coupon' => 'coupon',
        'plans' => 'plans',
        'agency_plans' => 'agencyPlans',
        'subscription_status_data' => 'subscriptionStatusData',
        'settings' => 'settings'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'current_domain' => 'setCurrentDomain',
        'workspace' => 'setWorkspace',
        'domains' => 'setDomains',
        'buttons' => 'setButtons',
        'validation_messages' => 'setValidationMessages',
        'user' => 'setUser',
        'coupon' => 'setCoupon',
        'plans' => 'setPlans',
        'agency_plans' => 'setAgencyPlans',
        'subscription_status_data' => 'setSubscriptionStatusData',
        'settings' => 'setSettings'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'current_domain' => 'getCurrentDomain',
        'workspace' => 'getWorkspace',
        'domains' => 'getDomains',
        'buttons' => 'getButtons',
        'validation_messages' => 'getValidationMessages',
        'user' => 'getUser',
        'coupon' => 'getCoupon',
        'plans' => 'getPlans',
        'agency_plans' => 'getAgencyPlans',
        'subscription_status_data' => 'getSubscriptionStatusData',
        'settings' => 'getSettings'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('current_domain', $data ?? [], null);
        $this->setIfExists('workspace', $data ?? [], null);
        $this->setIfExists('domains', $data ?? [], null);
        $this->setIfExists('buttons', $data ?? [], null);
        $this->setIfExists('validation_messages', $data ?? [], null);
        $this->setIfExists('user', $data ?? [], null);
        $this->setIfExists('coupon', $data ?? [], null);
        $this->setIfExists('plans', $data ?? [], null);
        $this->setIfExists('agency_plans', $data ?? [], null);
        $this->setIfExists('subscription_status_data', $data ?? [], null);
        $this->setIfExists('settings', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['domains'] === null) {
            $invalidProperties[] = "'domains' can't be null";
        }
        if ($this->container['buttons'] === null) {
            $invalidProperties[] = "'buttons' can't be null";
        }
        if ($this->container['validation_messages'] === null) {
            $invalidProperties[] = "'validation_messages' can't be null";
        }
        if ($this->container['user'] === null) {
            $invalidProperties[] = "'user' can't be null";
        }
        if ($this->container['plans'] === null) {
            $invalidProperties[] = "'plans' can't be null";
        }
        if ($this->container['agency_plans'] === null) {
            $invalidProperties[] = "'agency_plans' can't be null";
        }
        if ($this->container['settings'] === null) {
            $invalidProperties[] = "'settings' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets current_domain
     *
     * @return \cnb\api\Model\Domain|null
     */
    public function getCurrentDomain()
    {
        return $this->container['current_domain'];
    }

    /**
     * Sets current_domain
     *
     * @param \cnb\api\Model\Domain|null $current_domain current_domain
     *
     * @return self
     */
    public function setCurrentDomain($current_domain)
    {
        if (is_null($current_domain)) {
            throw new \InvalidArgumentException('non-nullable current_domain cannot be null');
        }
        $this->container['current_domain'] = $current_domain;

        return $this;
    }

    /**
     * Gets workspace
     *
     * @return \cnb\api\Model\Workspace|null
     */
    public function getWorkspace()
    {
        return $this->container['workspace'];
    }

    /**
     * Sets workspace
     *
     * @param \cnb\api\Model\Workspace|null $workspace workspace
     *
     * @return self
     */
    public function setWorkspace($workspace)
    {
        if (is_null($workspace)) {
            throw new \InvalidArgumentException('non-nullable workspace cannot be null');
        }
        $this->container['workspace'] = $workspace;

        return $this;
    }

    /**
     * Gets domains
     *
     * @return \cnb\api\Model\Domain[]
     */
    public function getDomains()
    {
        return $this->container['domains'];
    }

    /**
     * Sets domains
     *
     * @param \cnb\api\Model\Domain[] $domains domains
     *
     * @return self
     */
    public function setDomains($domains)
    {
        if (is_null($domains)) {
            throw new \InvalidArgumentException('non-nullable domains cannot be null');
        }
        $this->container['domains'] = $domains;

        return $this;
    }

    /**
     * Gets buttons
     *
     * @return \cnb\api\Model\Button[]
     */
    public function getButtons()
    {
        return $this->container['buttons'];
    }

    /**
     * Sets buttons
     *
     * @param \cnb\api\Model\Button[] $buttons buttons
     *
     * @return self
     */
    public function setButtons($buttons)
    {
        if (is_null($buttons)) {
            throw new \InvalidArgumentException('non-nullable buttons cannot be null');
        }
        $this->container['buttons'] = $buttons;

        return $this;
    }

    /**
     * Gets validation_messages
     *
     * @return \cnb\api\Model\ValidationResult[]
     */
    public function getValidationMessages()
    {
        return $this->container['validation_messages'];
    }

    /**
     * Sets validation_messages
     *
     * @param \cnb\api\Model\ValidationResult[] $validation_messages validation_messages
     *
     * @return self
     */
    public function setValidationMessages($validation_messages)
    {
        if (is_null($validation_messages)) {
            throw new \InvalidArgumentException('non-nullable validation_messages cannot be null');
        }
        $this->container['validation_messages'] = $validation_messages;

        return $this;
    }

    /**
     * Gets user
     *
     * @return \cnb\api\Model\User
     */
    public function getUser()
    {
        return $this->container['user'];
    }

    /**
     * Sets user
     *
     * @param \cnb\api\Model\User $user user
     *
     * @return self
     */
    public function setUser($user)
    {
        if (is_null($user)) {
            throw new \InvalidArgumentException('non-nullable user cannot be null');
        }
        $this->container['user'] = $user;

        return $this;
    }

    /**
     * Gets coupon
     *
     * @return \cnb\api\Model\PromotionCode|null
     */
    public function getCoupon()
    {
        return $this->container['coupon'];
    }

    /**
     * Sets coupon
     *
     * @param \cnb\api\Model\PromotionCode|null $coupon coupon
     *
     * @return self
     */
    public function setCoupon($coupon)
    {
        if (is_null($coupon)) {
            throw new \InvalidArgumentException('non-nullable coupon cannot be null');
        }
        $this->container['coupon'] = $coupon;

        return $this;
    }

    /**
     * Gets plans
     *
     * @return \cnb\api\Model\StripePlan[]
     */
    public function getPlans()
    {
        return $this->container['plans'];
    }

    /**
     * Sets plans
     *
     * @param \cnb\api\Model\StripePlan[] $plans plans
     *
     * @return self
     */
    public function setPlans($plans)
    {
        if (is_null($plans)) {
            throw new \InvalidArgumentException('non-nullable plans cannot be null');
        }
        $this->container['plans'] = $plans;

        return $this;
    }

    /**
     * Gets agency_plans
     *
     * @return \cnb\api\Model\StripeAgencyPlan[]
     */
    public function getAgencyPlans()
    {
        return $this->container['agency_plans'];
    }

    /**
     * Sets agency_plans
     *
     * @param \cnb\api\Model\StripeAgencyPlan[] $agency_plans agency_plans
     *
     * @return self
     */
    public function setAgencyPlans($agency_plans)
    {
        if (is_null($agency_plans)) {
            throw new \InvalidArgumentException('non-nullable agency_plans cannot be null');
        }
        $this->container['agency_plans'] = $agency_plans;

        return $this;
    }

    /**
     * Gets subscription_status_data
     *
     * @return \cnb\api\Model\SubscriptionStatusData|null
     */
    public function getSubscriptionStatusData()
    {
        return $this->container['subscription_status_data'];
    }

    /**
     * Sets subscription_status_data
     *
     * @param \cnb\api\Model\SubscriptionStatusData|null $subscription_status_data subscription_status_data
     *
     * @return self
     */
    public function setSubscriptionStatusData($subscription_status_data)
    {
        if (is_null($subscription_status_data)) {
            throw new \InvalidArgumentException('non-nullable subscription_status_data cannot be null');
        }
        $this->container['subscription_status_data'] = $subscription_status_data;

        return $this;
    }

    /**
     * Gets settings
     *
     * @return \cnb\api\Model\SettingsOptions
     */
    public function getSettings()
    {
        return $this->container['settings'];
    }

    /**
     * Sets settings
     *
     * @param \cnb\api\Model\SettingsOptions $settings settings
     *
     * @return self
     */
    public function setSettings($settings)
    {
        if (is_null($settings)) {
            throw new \InvalidArgumentException('non-nullable settings cannot be null');
        }
        $this->container['settings'] = $settings;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


