<?php
/**
 * GoogleAccountProfile
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  cnb\api
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * CallNowButton API
 *
 * API for CallNowButton. Includes auth, domains, buttons/actions/conditions, but also chat and admin features.
 *
 * The version of the OpenAPI document: 0.0.219-local
 * Contact: support@nowbuttons.com
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.12.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace cnb\api\Model;

use \ArrayAccess;
use \cnb\api\ObjectSerializer;

/**
 * GoogleAccountProfile Class Doc Comment
 *
 * @category Class
 * @package  cnb\api
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class GoogleAccountProfile implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'GoogleAccountProfile';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'sub' => 'string',
        'name' => 'string',
        'given_name' => 'string',
        'family_name' => 'string',
        'email' => 'string',
        'email_verified' => 'bool',
        'picture' => 'string',
        'hosted_domain' => 'string',
        'iss' => 'string',
        'aud' => 'string[]',
        'iat' => '\DateTime',
        'exp' => '\DateTime'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'sub' => null,
        'name' => null,
        'given_name' => null,
        'family_name' => null,
        'email' => null,
        'email_verified' => null,
        'picture' => null,
        'hosted_domain' => null,
        'iss' => null,
        'aud' => null,
        'iat' => 'date-time',
        'exp' => 'date-time'
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'sub' => false,
        'name' => false,
        'given_name' => false,
        'family_name' => false,
        'email' => false,
        'email_verified' => false,
        'picture' => false,
        'hosted_domain' => false,
        'iss' => false,
        'aud' => false,
        'iat' => false,
        'exp' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'sub' => 'sub',
        'name' => 'name',
        'given_name' => 'givenName',
        'family_name' => 'familyName',
        'email' => 'email',
        'email_verified' => 'emailVerified',
        'picture' => 'picture',
        'hosted_domain' => 'hostedDomain',
        'iss' => 'iss',
        'aud' => 'aud',
        'iat' => 'iat',
        'exp' => 'exp'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'sub' => 'setSub',
        'name' => 'setName',
        'given_name' => 'setGivenName',
        'family_name' => 'setFamilyName',
        'email' => 'setEmail',
        'email_verified' => 'setEmailVerified',
        'picture' => 'setPicture',
        'hosted_domain' => 'setHostedDomain',
        'iss' => 'setIss',
        'aud' => 'setAud',
        'iat' => 'setIat',
        'exp' => 'setExp'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'sub' => 'getSub',
        'name' => 'getName',
        'given_name' => 'getGivenName',
        'family_name' => 'getFamilyName',
        'email' => 'getEmail',
        'email_verified' => 'getEmailVerified',
        'picture' => 'getPicture',
        'hosted_domain' => 'getHostedDomain',
        'iss' => 'getIss',
        'aud' => 'getAud',
        'iat' => 'getIat',
        'exp' => 'getExp'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('sub', $data ?? [], null);
        $this->setIfExists('name', $data ?? [], null);
        $this->setIfExists('given_name', $data ?? [], null);
        $this->setIfExists('family_name', $data ?? [], null);
        $this->setIfExists('email', $data ?? [], null);
        $this->setIfExists('email_verified', $data ?? [], null);
        $this->setIfExists('picture', $data ?? [], null);
        $this->setIfExists('hosted_domain', $data ?? [], null);
        $this->setIfExists('iss', $data ?? [], null);
        $this->setIfExists('aud', $data ?? [], null);
        $this->setIfExists('iat', $data ?? [], null);
        $this->setIfExists('exp', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['sub'] === null) {
            $invalidProperties[] = "'sub' can't be null";
        }
        if ($this->container['name'] === null) {
            $invalidProperties[] = "'name' can't be null";
        }
        if ($this->container['given_name'] === null) {
            $invalidProperties[] = "'given_name' can't be null";
        }
        if ($this->container['family_name'] === null) {
            $invalidProperties[] = "'family_name' can't be null";
        }
        if ($this->container['email'] === null) {
            $invalidProperties[] = "'email' can't be null";
        }
        if ($this->container['email_verified'] === null) {
            $invalidProperties[] = "'email_verified' can't be null";
        }
        if ($this->container['picture'] === null) {
            $invalidProperties[] = "'picture' can't be null";
        }
        if ($this->container['hosted_domain'] === null) {
            $invalidProperties[] = "'hosted_domain' can't be null";
        }
        if ($this->container['iss'] === null) {
            $invalidProperties[] = "'iss' can't be null";
        }
        if ($this->container['aud'] === null) {
            $invalidProperties[] = "'aud' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets sub
     *
     * @return string
     */
    public function getSub()
    {
        return $this->container['sub'];
    }

    /**
     * Sets sub
     *
     * @param string $sub sub
     *
     * @return self
     */
    public function setSub($sub)
    {
        if (is_null($sub)) {
            throw new \InvalidArgumentException('non-nullable sub cannot be null');
        }
        $this->container['sub'] = $sub;

        return $this;
    }

    /**
     * Gets name
     *
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string $name name
     *
     * @return self
     */
    public function setName($name)
    {
        if (is_null($name)) {
            throw new \InvalidArgumentException('non-nullable name cannot be null');
        }
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets given_name
     *
     * @return string
     */
    public function getGivenName()
    {
        return $this->container['given_name'];
    }

    /**
     * Sets given_name
     *
     * @param string $given_name given_name
     *
     * @return self
     */
    public function setGivenName($given_name)
    {
        if (is_null($given_name)) {
            throw new \InvalidArgumentException('non-nullable given_name cannot be null');
        }
        $this->container['given_name'] = $given_name;

        return $this;
    }

    /**
     * Gets family_name
     *
     * @return string
     */
    public function getFamilyName()
    {
        return $this->container['family_name'];
    }

    /**
     * Sets family_name
     *
     * @param string $family_name family_name
     *
     * @return self
     */
    public function setFamilyName($family_name)
    {
        if (is_null($family_name)) {
            throw new \InvalidArgumentException('non-nullable family_name cannot be null');
        }
        $this->container['family_name'] = $family_name;

        return $this;
    }

    /**
     * Gets email
     *
     * @return string
     */
    public function getEmail()
    {
        return $this->container['email'];
    }

    /**
     * Sets email
     *
     * @param string $email email
     *
     * @return self
     */
    public function setEmail($email)
    {
        if (is_null($email)) {
            throw new \InvalidArgumentException('non-nullable email cannot be null');
        }
        $this->container['email'] = $email;

        return $this;
    }

    /**
     * Gets email_verified
     *
     * @return bool
     */
    public function getEmailVerified()
    {
        return $this->container['email_verified'];
    }

    /**
     * Sets email_verified
     *
     * @param bool $email_verified email_verified
     *
     * @return self
     */
    public function setEmailVerified($email_verified)
    {
        if (is_null($email_verified)) {
            throw new \InvalidArgumentException('non-nullable email_verified cannot be null');
        }
        $this->container['email_verified'] = $email_verified;

        return $this;
    }

    /**
     * Gets picture
     *
     * @return string
     */
    public function getPicture()
    {
        return $this->container['picture'];
    }

    /**
     * Sets picture
     *
     * @param string $picture picture
     *
     * @return self
     */
    public function setPicture($picture)
    {
        if (is_null($picture)) {
            throw new \InvalidArgumentException('non-nullable picture cannot be null');
        }
        $this->container['picture'] = $picture;

        return $this;
    }

    /**
     * Gets hosted_domain
     *
     * @return string
     */
    public function getHostedDomain()
    {
        return $this->container['hosted_domain'];
    }

    /**
     * Sets hosted_domain
     *
     * @param string $hosted_domain hosted_domain
     *
     * @return self
     */
    public function setHostedDomain($hosted_domain)
    {
        if (is_null($hosted_domain)) {
            throw new \InvalidArgumentException('non-nullable hosted_domain cannot be null');
        }
        $this->container['hosted_domain'] = $hosted_domain;

        return $this;
    }

    /**
     * Gets iss
     *
     * @return string
     */
    public function getIss()
    {
        return $this->container['iss'];
    }

    /**
     * Sets iss
     *
     * @param string $iss iss
     *
     * @return self
     */
    public function setIss($iss)
    {
        if (is_null($iss)) {
            throw new \InvalidArgumentException('non-nullable iss cannot be null');
        }
        $this->container['iss'] = $iss;

        return $this;
    }

    /**
     * Gets aud
     *
     * @return string[]
     */
    public function getAud()
    {
        return $this->container['aud'];
    }

    /**
     * Sets aud
     *
     * @param string[] $aud aud
     *
     * @return self
     */
    public function setAud($aud)
    {
        if (is_null($aud)) {
            throw new \InvalidArgumentException('non-nullable aud cannot be null');
        }
        $this->container['aud'] = $aud;

        return $this;
    }

    /**
     * Gets iat
     *
     * @return \DateTime|null
     */
    public function getIat()
    {
        return $this->container['iat'];
    }

    /**
     * Sets iat
     *
     * @param \DateTime|null $iat iat
     *
     * @return self
     */
    public function setIat($iat)
    {
        if (is_null($iat)) {
            throw new \InvalidArgumentException('non-nullable iat cannot be null');
        }
        $this->container['iat'] = $iat;

        return $this;
    }

    /**
     * Gets exp
     *
     * @return \DateTime|null
     */
    public function getExp()
    {
        return $this->container['exp'];
    }

    /**
     * Sets exp
     *
     * @param \DateTime|null $exp exp
     *
     * @return self
     */
    public function setExp($exp)
    {
        if (is_null($exp)) {
            throw new \InvalidArgumentException('non-nullable exp cannot be null');
        }
        $this->container['exp'] = $exp;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


