<?php
/**
 * ConfigurationBasedStrategyConfig
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  cnb\api
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * CallNowButton API
 *
 * API for CallNowButton. Includes auth, domains, buttons/actions/conditions, but also chat and admin features.
 *
 * The version of the OpenAPI document: 0.0.219-local
 * Contact: support@nowbuttons.com
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.12.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace cnb\api\Model;
use \cnb\api\ObjectSerializer;

/**
 * ConfigurationBasedStrategyConfig Class Doc Comment
 *
 * @category Class
 * @package  cnb\api
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class ConfigurationBasedStrategyConfig extends SchedulingStrategyConfig
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ConfigurationBasedStrategyConfig';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'slot_duration' => 'int',
        'availability_windows' => '\cnb\api\Model\AvailabilityWindow[]',
        'buffer_between_slots' => 'int',
        'advance_booking_days' => 'int',
        'last_bookable_date' => '\DateTime'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'slot_duration' => 'int32',
        'availability_windows' => null,
        'buffer_between_slots' => 'int32',
        'advance_booking_days' => 'int64',
        'last_bookable_date' => 'date-time'
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'slot_duration' => false,
        'availability_windows' => false,
        'buffer_between_slots' => false,
        'advance_booking_days' => false,
        'last_bookable_date' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes + parent::openAPITypes();
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats + parent::openAPIFormats();
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables + parent::openAPINullables();
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'slot_duration' => 'slotDuration',
        'availability_windows' => 'availabilityWindows',
        'buffer_between_slots' => 'bufferBetweenSlots',
        'advance_booking_days' => 'advanceBookingDays',
        'last_bookable_date' => 'lastBookableDate'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'slot_duration' => 'setSlotDuration',
        'availability_windows' => 'setAvailabilityWindows',
        'buffer_between_slots' => 'setBufferBetweenSlots',
        'advance_booking_days' => 'setAdvanceBookingDays',
        'last_bookable_date' => 'setLastBookableDate'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'slot_duration' => 'getSlotDuration',
        'availability_windows' => 'getAvailabilityWindows',
        'buffer_between_slots' => 'getBufferBetweenSlots',
        'advance_booking_days' => 'getAdvanceBookingDays',
        'last_bookable_date' => 'getLastBookableDate'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return parent::attributeMap() + self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return parent::setters() + self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return parent::getters() + self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }



    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        parent::__construct($data);

        $this->setIfExists('slot_duration', $data ?? [], null);
        $this->setIfExists('availability_windows', $data ?? [], null);
        $this->setIfExists('buffer_between_slots', $data ?? [], null);
        $this->setIfExists('advance_booking_days', $data ?? [], null);
        $this->setIfExists('last_bookable_date', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = parent::listInvalidProperties();

        if ($this->container['slot_duration'] === null) {
            $invalidProperties[] = "'slot_duration' can't be null";
        }
        if ($this->container['availability_windows'] === null) {
            $invalidProperties[] = "'availability_windows' can't be null";
        }
        if ($this->container['buffer_between_slots'] === null) {
            $invalidProperties[] = "'buffer_between_slots' can't be null";
        }
        if ($this->container['advance_booking_days'] === null) {
            $invalidProperties[] = "'advance_booking_days' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets slot_duration
     *
     * @return int
     */
    public function getSlotDuration()
    {
        return $this->container['slot_duration'];
    }

    /**
     * Sets slot_duration
     *
     * @param int $slot_duration slot_duration
     *
     * @return self
     */
    public function setSlotDuration($slot_duration)
    {
        if (is_null($slot_duration)) {
            throw new \InvalidArgumentException('non-nullable slot_duration cannot be null');
        }
        $this->container['slot_duration'] = $slot_duration;

        return $this;
    }

    /**
     * Gets availability_windows
     *
     * @return \cnb\api\Model\AvailabilityWindow[]
     */
    public function getAvailabilityWindows()
    {
        return $this->container['availability_windows'];
    }

    /**
     * Sets availability_windows
     *
     * @param \cnb\api\Model\AvailabilityWindow[] $availability_windows availability_windows
     *
     * @return self
     */
    public function setAvailabilityWindows($availability_windows)
    {
        if (is_null($availability_windows)) {
            throw new \InvalidArgumentException('non-nullable availability_windows cannot be null');
        }
        $this->container['availability_windows'] = $availability_windows;

        return $this;
    }

    /**
     * Gets buffer_between_slots
     *
     * @return int
     */
    public function getBufferBetweenSlots()
    {
        return $this->container['buffer_between_slots'];
    }

    /**
     * Sets buffer_between_slots
     *
     * @param int $buffer_between_slots buffer_between_slots
     *
     * @return self
     */
    public function setBufferBetweenSlots($buffer_between_slots)
    {
        if (is_null($buffer_between_slots)) {
            throw new \InvalidArgumentException('non-nullable buffer_between_slots cannot be null');
        }
        $this->container['buffer_between_slots'] = $buffer_between_slots;

        return $this;
    }

    /**
     * Gets advance_booking_days
     *
     * @return int
     */
    public function getAdvanceBookingDays()
    {
        return $this->container['advance_booking_days'];
    }

    /**
     * Sets advance_booking_days
     *
     * @param int $advance_booking_days How many days in advance to generate slots.
     *
     * @return self
     */
    public function setAdvanceBookingDays($advance_booking_days)
    {
        if (is_null($advance_booking_days)) {
            throw new \InvalidArgumentException('non-nullable advance_booking_days cannot be null');
        }
        $this->container['advance_booking_days'] = $advance_booking_days;

        return $this;
    }

    /**
     * Gets last_bookable_date
     *
     * @return \DateTime|null
     */
    public function getLastBookableDate()
    {
        return $this->container['last_bookable_date'];
    }

    /**
     * Sets last_bookable_date
     *
     * @param \DateTime|null $last_bookable_date The last possible bookable Instant, after this the Meeting is considered expired.
     *
     * @return self
     */
    public function setLastBookableDate($last_bookable_date)
    {
        if (is_null($last_bookable_date)) {
            throw new \InvalidArgumentException('non-nullable last_bookable_date cannot be null');
        }
        $this->container['last_bookable_date'] = $last_bookable_date;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


