<?php
/**
 * ButtonOptions
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  cnb\api
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * CallNowButton API
 *
 * API for CallNowButton. Includes auth, domains, buttons/actions/conditions, but also chat and admin features.
 *
 * The version of the OpenAPI document: 0.0.219-local
 * Contact: support@nowbuttons.com
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.12.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace cnb\api\Model;

use \ArrayAccess;
use \cnb\api\ObjectSerializer;

/**
 * ButtonOptions Class Doc Comment
 *
 * @category Class
 * @package  cnb\api
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class ButtonOptions implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ButtonOptions';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'placement' => 'string',
        'position' => 'string',
        'display_mode' => 'string',
        'animation' => 'string',
        'scroll' => '\cnb\api\Model\ScrollOptions',
        'css_classes' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'placement' => null,
        'position' => null,
        'display_mode' => null,
        'animation' => null,
        'scroll' => null,
        'css_classes' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'placement' => false,
        'position' => false,
        'display_mode' => false,
        'animation' => false,
        'scroll' => false,
        'css_classes' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'placement' => 'placement',
        'position' => 'position',
        'display_mode' => 'displayMode',
        'animation' => 'animation',
        'scroll' => 'scroll',
        'css_classes' => 'cssClasses'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'placement' => 'setPlacement',
        'position' => 'setPosition',
        'display_mode' => 'setDisplayMode',
        'animation' => 'setAnimation',
        'scroll' => 'setScroll',
        'css_classes' => 'setCssClasses'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'placement' => 'getPlacement',
        'position' => 'getPosition',
        'display_mode' => 'getDisplayMode',
        'animation' => 'getAnimation',
        'scroll' => 'getScroll',
        'css_classes' => 'getCssClasses'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const PLACEMENT__DEFAULT = 'DEFAULT';
    public const PLACEMENT_BOTTOM_LEFT = 'BOTTOM_LEFT';
    public const PLACEMENT_BOTTOM_CENTER = 'BOTTOM_CENTER';
    public const PLACEMENT_BOTTOM_RIGHT = 'BOTTOM_RIGHT';
    public const PLACEMENT_MIDDLE_LEFT = 'MIDDLE_LEFT';
    public const PLACEMENT_MIDDLE_RIGHT = 'MIDDLE_RIGHT';
    public const PLACEMENT_TOP_LEFT = 'TOP_LEFT';
    public const PLACEMENT_TOP_CENTER = 'TOP_CENTER';
    public const PLACEMENT_TOP_RIGHT = 'TOP_RIGHT';
    public const POSITION__DEFAULT = 'DEFAULT';
    public const POSITION_FIXED = 'FIXED';
    public const POSITION_ABSOLUTE = 'ABSOLUTE';
    public const DISPLAY_MODE_ALWAYS = 'ALWAYS';
    public const DISPLAY_MODE_MOBILE_ONLY = 'MOBILE_ONLY';
    public const DISPLAY_MODE_DESKTOP_ONLY = 'DESKTOP_ONLY';
    public const ANIMATION_NONE = 'NONE';
    public const ANIMATION_SHAKE = 'SHAKE';
    public const ANIMATION_TADA = 'TADA';
    public const ANIMATION_SONAR_LIGHT = 'SONAR_LIGHT';
    public const ANIMATION_SONAR_DARK = 'SONAR_DARK';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getPlacementAllowableValues()
    {
        return [
            self::PLACEMENT__DEFAULT,
            self::PLACEMENT_BOTTOM_LEFT,
            self::PLACEMENT_BOTTOM_CENTER,
            self::PLACEMENT_BOTTOM_RIGHT,
            self::PLACEMENT_MIDDLE_LEFT,
            self::PLACEMENT_MIDDLE_RIGHT,
            self::PLACEMENT_TOP_LEFT,
            self::PLACEMENT_TOP_CENTER,
            self::PLACEMENT_TOP_RIGHT,
        ];
    }

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getPositionAllowableValues()
    {
        return [
            self::POSITION__DEFAULT,
            self::POSITION_FIXED,
            self::POSITION_ABSOLUTE,
        ];
    }

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getDisplayModeAllowableValues()
    {
        return [
            self::DISPLAY_MODE_ALWAYS,
            self::DISPLAY_MODE_MOBILE_ONLY,
            self::DISPLAY_MODE_DESKTOP_ONLY,
        ];
    }

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getAnimationAllowableValues()
    {
        return [
            self::ANIMATION_NONE,
            self::ANIMATION_SHAKE,
            self::ANIMATION_TADA,
            self::ANIMATION_SONAR_LIGHT,
            self::ANIMATION_SONAR_DARK,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('placement', $data ?? [], null);
        $this->setIfExists('position', $data ?? [], null);
        $this->setIfExists('display_mode', $data ?? [], null);
        $this->setIfExists('animation', $data ?? [], null);
        $this->setIfExists('scroll', $data ?? [], null);
        $this->setIfExists('css_classes', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['placement'] === null) {
            $invalidProperties[] = "'placement' can't be null";
        }
        $allowedValues = $this->getPlacementAllowableValues();
        if (!is_null($this->container['placement']) && !in_array($this->container['placement'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'placement', must be one of '%s'",
                $this->container['placement'],
                implode("', '", $allowedValues)
            );
        }

        $allowedValues = $this->getPositionAllowableValues();
        if (!is_null($this->container['position']) && !in_array($this->container['position'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'position', must be one of '%s'",
                $this->container['position'],
                implode("', '", $allowedValues)
            );
        }

        $allowedValues = $this->getDisplayModeAllowableValues();
        if (!is_null($this->container['display_mode']) && !in_array($this->container['display_mode'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'display_mode', must be one of '%s'",
                $this->container['display_mode'],
                implode("', '", $allowedValues)
            );
        }

        $allowedValues = $this->getAnimationAllowableValues();
        if (!is_null($this->container['animation']) && !in_array($this->container['animation'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'animation', must be one of '%s'",
                $this->container['animation'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets placement
     *
     * @return string
     */
    public function getPlacement()
    {
        return $this->container['placement'];
    }

    /**
     * Sets placement
     *
     * @param string $placement placement
     *
     * @return self
     */
    public function setPlacement($placement)
    {
        if (is_null($placement)) {
            throw new \InvalidArgumentException('non-nullable placement cannot be null');
        }
        $allowedValues = $this->getPlacementAllowableValues();
        if (!in_array($placement, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'placement', must be one of '%s'",
                    $placement,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['placement'] = $placement;

        return $this;
    }

    /**
     * Gets position
     *
     * @return string|null
     */
    public function getPosition()
    {
        return $this->container['position'];
    }

    /**
     * Sets position
     *
     * @param string|null $position position
     *
     * @return self
     */
    public function setPosition($position)
    {
        if (is_null($position)) {
            throw new \InvalidArgumentException('non-nullable position cannot be null');
        }
        $allowedValues = $this->getPositionAllowableValues();
        if (!in_array($position, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'position', must be one of '%s'",
                    $position,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['position'] = $position;

        return $this;
    }

    /**
     * Gets display_mode
     *
     * @return string|null
     */
    public function getDisplayMode()
    {
        return $this->container['display_mode'];
    }

    /**
     * Sets display_mode
     *
     * @param string|null $display_mode display_mode
     *
     * @return self
     */
    public function setDisplayMode($display_mode)
    {
        if (is_null($display_mode)) {
            throw new \InvalidArgumentException('non-nullable display_mode cannot be null');
        }
        $allowedValues = $this->getDisplayModeAllowableValues();
        if (!in_array($display_mode, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'display_mode', must be one of '%s'",
                    $display_mode,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['display_mode'] = $display_mode;

        return $this;
    }

    /**
     * Gets animation
     *
     * @return string|null
     */
    public function getAnimation()
    {
        return $this->container['animation'];
    }

    /**
     * Sets animation
     *
     * @param string|null $animation animation
     *
     * @return self
     */
    public function setAnimation($animation)
    {
        if (is_null($animation)) {
            throw new \InvalidArgumentException('non-nullable animation cannot be null');
        }
        $allowedValues = $this->getAnimationAllowableValues();
        if (!in_array($animation, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'animation', must be one of '%s'",
                    $animation,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['animation'] = $animation;

        return $this;
    }

    /**
     * Gets scroll
     *
     * @return \cnb\api\Model\ScrollOptions|null
     */
    public function getScroll()
    {
        return $this->container['scroll'];
    }

    /**
     * Sets scroll
     *
     * @param \cnb\api\Model\ScrollOptions|null $scroll scroll
     *
     * @return self
     */
    public function setScroll($scroll)
    {
        if (is_null($scroll)) {
            throw new \InvalidArgumentException('non-nullable scroll cannot be null');
        }
        $this->container['scroll'] = $scroll;

        return $this;
    }

    /**
     * Gets css_classes
     *
     * @return string|null
     */
    public function getCssClasses()
    {
        return $this->container['css_classes'];
    }

    /**
     * Sets css_classes
     *
     * @param string|null $css_classes css_classes
     *
     * @return self
     */
    public function setCssClasses($css_classes)
    {
        if (is_null($css_classes)) {
            throw new \InvalidArgumentException('non-nullable css_classes cannot be null');
        }
        $this->container['css_classes'] = $css_classes;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


