<?php
/**
 * ApiServerExceptionResponse
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  cnb\api
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * CallNowButton API
 *
 * API for CallNowButton. Includes auth, domains, buttons/actions/conditions, but also chat and admin features.
 *
 * The version of the OpenAPI document: 0.0.219-local
 * Contact: support@nowbuttons.com
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.12.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace cnb\api\Model;

use \ArrayAccess;
use \cnb\api\ObjectSerializer;

/**
 * ApiServerExceptionResponse Class Doc Comment
 *
 * @category Class
 * @package  cnb\api
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class ApiServerExceptionResponse implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ApiServerExceptionResponse';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'code' => 'string',
        'timestamp' => '\DateTime',
        'status' => 'int',
        'error' => 'string',
        'message' => 'string',
        'path' => 'string',
        'details' => 'array<string,mixed>'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'code' => null,
        'timestamp' => 'date-time',
        'status' => 'int32',
        'error' => null,
        'message' => null,
        'path' => null,
        'details' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'code' => false,
        'timestamp' => false,
        'status' => false,
        'error' => false,
        'message' => false,
        'path' => false,
        'details' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'code' => 'code',
        'timestamp' => 'timestamp',
        'status' => 'status',
        'error' => 'error',
        'message' => 'message',
        'path' => 'path',
        'details' => 'details'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'code' => 'setCode',
        'timestamp' => 'setTimestamp',
        'status' => 'setStatus',
        'error' => 'setError',
        'message' => 'setMessage',
        'path' => 'setPath',
        'details' => 'setDetails'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'code' => 'getCode',
        'timestamp' => 'getTimestamp',
        'status' => 'getStatus',
        'error' => 'getError',
        'message' => 'getMessage',
        'path' => 'getPath',
        'details' => 'getDetails'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const ERROR__100_CONTINUE = '100 CONTINUE';
    public const ERROR__101_SWITCHING_PROTOCOLS = '101 SWITCHING_PROTOCOLS';
    public const ERROR__102_PROCESSING = '102 PROCESSING';
    public const ERROR__103_EARLY_HINTS = '103 EARLY_HINTS';
    public const ERROR__103_CHECKPOINT = '103 CHECKPOINT';
    public const ERROR__200_OK = '200 OK';
    public const ERROR__201_CREATED = '201 CREATED';
    public const ERROR__202_ACCEPTED = '202 ACCEPTED';
    public const ERROR__203_NON_AUTHORITATIVE_INFORMATION = '203 NON_AUTHORITATIVE_INFORMATION';
    public const ERROR__204_NO_CONTENT = '204 NO_CONTENT';
    public const ERROR__205_RESET_CONTENT = '205 RESET_CONTENT';
    public const ERROR__206_PARTIAL_CONTENT = '206 PARTIAL_CONTENT';
    public const ERROR__207_MULTI_STATUS = '207 MULTI_STATUS';
    public const ERROR__208_ALREADY_REPORTED = '208 ALREADY_REPORTED';
    public const ERROR__226_IM_USED = '226 IM_USED';
    public const ERROR__300_MULTIPLE_CHOICES = '300 MULTIPLE_CHOICES';
    public const ERROR__301_MOVED_PERMANENTLY = '301 MOVED_PERMANENTLY';
    public const ERROR__302_FOUND = '302 FOUND';
    public const ERROR__302_MOVED_TEMPORARILY = '302 MOVED_TEMPORARILY';
    public const ERROR__303_SEE_OTHER = '303 SEE_OTHER';
    public const ERROR__304_NOT_MODIFIED = '304 NOT_MODIFIED';
    public const ERROR__305_USE_PROXY = '305 USE_PROXY';
    public const ERROR__307_TEMPORARY_REDIRECT = '307 TEMPORARY_REDIRECT';
    public const ERROR__308_PERMANENT_REDIRECT = '308 PERMANENT_REDIRECT';
    public const ERROR__400_BAD_REQUEST = '400 BAD_REQUEST';
    public const ERROR__401_UNAUTHORIZED = '401 UNAUTHORIZED';
    public const ERROR__402_PAYMENT_REQUIRED = '402 PAYMENT_REQUIRED';
    public const ERROR__403_FORBIDDEN = '403 FORBIDDEN';
    public const ERROR__404_NOT_FOUND = '404 NOT_FOUND';
    public const ERROR__405_METHOD_NOT_ALLOWED = '405 METHOD_NOT_ALLOWED';
    public const ERROR__406_NOT_ACCEPTABLE = '406 NOT_ACCEPTABLE';
    public const ERROR__407_PROXY_AUTHENTICATION_REQUIRED = '407 PROXY_AUTHENTICATION_REQUIRED';
    public const ERROR__408_REQUEST_TIMEOUT = '408 REQUEST_TIMEOUT';
    public const ERROR__409_CONFLICT = '409 CONFLICT';
    public const ERROR__410_GONE = '410 GONE';
    public const ERROR__411_LENGTH_REQUIRED = '411 LENGTH_REQUIRED';
    public const ERROR__412_PRECONDITION_FAILED = '412 PRECONDITION_FAILED';
    public const ERROR__413_PAYLOAD_TOO_LARGE = '413 PAYLOAD_TOO_LARGE';
    public const ERROR__413_REQUEST_ENTITY_TOO_LARGE = '413 REQUEST_ENTITY_TOO_LARGE';
    public const ERROR__414_URI_TOO_LONG = '414 URI_TOO_LONG';
    public const ERROR__414_REQUEST_URI_TOO_LONG = '414 REQUEST_URI_TOO_LONG';
    public const ERROR__415_UNSUPPORTED_MEDIA_TYPE = '415 UNSUPPORTED_MEDIA_TYPE';
    public const ERROR__416_REQUESTED_RANGE_NOT_SATISFIABLE = '416 REQUESTED_RANGE_NOT_SATISFIABLE';
    public const ERROR__417_EXPECTATION_FAILED = '417 EXPECTATION_FAILED';
    public const ERROR__418_I_AM_A_TEAPOT = '418 I_AM_A_TEAPOT';
    public const ERROR__419_INSUFFICIENT_SPACE_ON_RESOURCE = '419 INSUFFICIENT_SPACE_ON_RESOURCE';
    public const ERROR__420_METHOD_FAILURE = '420 METHOD_FAILURE';
    public const ERROR__421_DESTINATION_LOCKED = '421 DESTINATION_LOCKED';
    public const ERROR__422_UNPROCESSABLE_ENTITY = '422 UNPROCESSABLE_ENTITY';
    public const ERROR__423_LOCKED = '423 LOCKED';
    public const ERROR__424_FAILED_DEPENDENCY = '424 FAILED_DEPENDENCY';
    public const ERROR__425_TOO_EARLY = '425 TOO_EARLY';
    public const ERROR__426_UPGRADE_REQUIRED = '426 UPGRADE_REQUIRED';
    public const ERROR__428_PRECONDITION_REQUIRED = '428 PRECONDITION_REQUIRED';
    public const ERROR__429_TOO_MANY_REQUESTS = '429 TOO_MANY_REQUESTS';
    public const ERROR__431_REQUEST_HEADER_FIELDS_TOO_LARGE = '431 REQUEST_HEADER_FIELDS_TOO_LARGE';
    public const ERROR__451_UNAVAILABLE_FOR_LEGAL_REASONS = '451 UNAVAILABLE_FOR_LEGAL_REASONS';
    public const ERROR__500_INTERNAL_SERVER_ERROR = '500 INTERNAL_SERVER_ERROR';
    public const ERROR__501_NOT_IMPLEMENTED = '501 NOT_IMPLEMENTED';
    public const ERROR__502_BAD_GATEWAY = '502 BAD_GATEWAY';
    public const ERROR__503_SERVICE_UNAVAILABLE = '503 SERVICE_UNAVAILABLE';
    public const ERROR__504_GATEWAY_TIMEOUT = '504 GATEWAY_TIMEOUT';
    public const ERROR__505_HTTP_VERSION_NOT_SUPPORTED = '505 HTTP_VERSION_NOT_SUPPORTED';
    public const ERROR__506_VARIANT_ALSO_NEGOTIATES = '506 VARIANT_ALSO_NEGOTIATES';
    public const ERROR__507_INSUFFICIENT_STORAGE = '507 INSUFFICIENT_STORAGE';
    public const ERROR__508_LOOP_DETECTED = '508 LOOP_DETECTED';
    public const ERROR__509_BANDWIDTH_LIMIT_EXCEEDED = '509 BANDWIDTH_LIMIT_EXCEEDED';
    public const ERROR__510_NOT_EXTENDED = '510 NOT_EXTENDED';
    public const ERROR__511_NETWORK_AUTHENTICATION_REQUIRED = '511 NETWORK_AUTHENTICATION_REQUIRED';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getErrorAllowableValues()
    {
        return [
            self::ERROR__100_CONTINUE,
            self::ERROR__101_SWITCHING_PROTOCOLS,
            self::ERROR__102_PROCESSING,
            self::ERROR__103_EARLY_HINTS,
            self::ERROR__103_CHECKPOINT,
            self::ERROR__200_OK,
            self::ERROR__201_CREATED,
            self::ERROR__202_ACCEPTED,
            self::ERROR__203_NON_AUTHORITATIVE_INFORMATION,
            self::ERROR__204_NO_CONTENT,
            self::ERROR__205_RESET_CONTENT,
            self::ERROR__206_PARTIAL_CONTENT,
            self::ERROR__207_MULTI_STATUS,
            self::ERROR__208_ALREADY_REPORTED,
            self::ERROR__226_IM_USED,
            self::ERROR__300_MULTIPLE_CHOICES,
            self::ERROR__301_MOVED_PERMANENTLY,
            self::ERROR__302_FOUND,
            self::ERROR__302_MOVED_TEMPORARILY,
            self::ERROR__303_SEE_OTHER,
            self::ERROR__304_NOT_MODIFIED,
            self::ERROR__305_USE_PROXY,
            self::ERROR__307_TEMPORARY_REDIRECT,
            self::ERROR__308_PERMANENT_REDIRECT,
            self::ERROR__400_BAD_REQUEST,
            self::ERROR__401_UNAUTHORIZED,
            self::ERROR__402_PAYMENT_REQUIRED,
            self::ERROR__403_FORBIDDEN,
            self::ERROR__404_NOT_FOUND,
            self::ERROR__405_METHOD_NOT_ALLOWED,
            self::ERROR__406_NOT_ACCEPTABLE,
            self::ERROR__407_PROXY_AUTHENTICATION_REQUIRED,
            self::ERROR__408_REQUEST_TIMEOUT,
            self::ERROR__409_CONFLICT,
            self::ERROR__410_GONE,
            self::ERROR__411_LENGTH_REQUIRED,
            self::ERROR__412_PRECONDITION_FAILED,
            self::ERROR__413_PAYLOAD_TOO_LARGE,
            self::ERROR__413_REQUEST_ENTITY_TOO_LARGE,
            self::ERROR__414_URI_TOO_LONG,
            self::ERROR__414_REQUEST_URI_TOO_LONG,
            self::ERROR__415_UNSUPPORTED_MEDIA_TYPE,
            self::ERROR__416_REQUESTED_RANGE_NOT_SATISFIABLE,
            self::ERROR__417_EXPECTATION_FAILED,
            self::ERROR__418_I_AM_A_TEAPOT,
            self::ERROR__419_INSUFFICIENT_SPACE_ON_RESOURCE,
            self::ERROR__420_METHOD_FAILURE,
            self::ERROR__421_DESTINATION_LOCKED,
            self::ERROR__422_UNPROCESSABLE_ENTITY,
            self::ERROR__423_LOCKED,
            self::ERROR__424_FAILED_DEPENDENCY,
            self::ERROR__425_TOO_EARLY,
            self::ERROR__426_UPGRADE_REQUIRED,
            self::ERROR__428_PRECONDITION_REQUIRED,
            self::ERROR__429_TOO_MANY_REQUESTS,
            self::ERROR__431_REQUEST_HEADER_FIELDS_TOO_LARGE,
            self::ERROR__451_UNAVAILABLE_FOR_LEGAL_REASONS,
            self::ERROR__500_INTERNAL_SERVER_ERROR,
            self::ERROR__501_NOT_IMPLEMENTED,
            self::ERROR__502_BAD_GATEWAY,
            self::ERROR__503_SERVICE_UNAVAILABLE,
            self::ERROR__504_GATEWAY_TIMEOUT,
            self::ERROR__505_HTTP_VERSION_NOT_SUPPORTED,
            self::ERROR__506_VARIANT_ALSO_NEGOTIATES,
            self::ERROR__507_INSUFFICIENT_STORAGE,
            self::ERROR__508_LOOP_DETECTED,
            self::ERROR__509_BANDWIDTH_LIMIT_EXCEEDED,
            self::ERROR__510_NOT_EXTENDED,
            self::ERROR__511_NETWORK_AUTHENTICATION_REQUIRED,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('code', $data ?? [], null);
        $this->setIfExists('timestamp', $data ?? [], null);
        $this->setIfExists('status', $data ?? [], null);
        $this->setIfExists('error', $data ?? [], null);
        $this->setIfExists('message', $data ?? [], null);
        $this->setIfExists('path', $data ?? [], null);
        $this->setIfExists('details', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['code'] === null) {
            $invalidProperties[] = "'code' can't be null";
        }
        if ($this->container['timestamp'] === null) {
            $invalidProperties[] = "'timestamp' can't be null";
        }
        if ($this->container['status'] === null) {
            $invalidProperties[] = "'status' can't be null";
        }
        if ($this->container['error'] === null) {
            $invalidProperties[] = "'error' can't be null";
        }
        $allowedValues = $this->getErrorAllowableValues();
        if (!is_null($this->container['error']) && !in_array($this->container['error'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'error', must be one of '%s'",
                $this->container['error'],
                implode("', '", $allowedValues)
            );
        }

        if ($this->container['message'] === null) {
            $invalidProperties[] = "'message' can't be null";
        }
        if ($this->container['path'] === null) {
            $invalidProperties[] = "'path' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets code
     *
     * @return string
     */
    public function getCode()
    {
        return $this->container['code'];
    }

    /**
     * Sets code
     *
     * @param string $code code
     *
     * @return self
     */
    public function setCode($code)
    {
        if (is_null($code)) {
            throw new \InvalidArgumentException('non-nullable code cannot be null');
        }
        $this->container['code'] = $code;

        return $this;
    }

    /**
     * Gets timestamp
     *
     * @return \DateTime
     */
    public function getTimestamp()
    {
        return $this->container['timestamp'];
    }

    /**
     * Sets timestamp
     *
     * @param \DateTime $timestamp timestamp
     *
     * @return self
     */
    public function setTimestamp($timestamp)
    {
        if (is_null($timestamp)) {
            throw new \InvalidArgumentException('non-nullable timestamp cannot be null');
        }
        $this->container['timestamp'] = $timestamp;

        return $this;
    }

    /**
     * Gets status
     *
     * @return int
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     *
     * @param int $status status
     *
     * @return self
     */
    public function setStatus($status)
    {
        if (is_null($status)) {
            throw new \InvalidArgumentException('non-nullable status cannot be null');
        }
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets error
     *
     * @return string
     */
    public function getError()
    {
        return $this->container['error'];
    }

    /**
     * Sets error
     *
     * @param string $error error
     *
     * @return self
     */
    public function setError($error)
    {
        if (is_null($error)) {
            throw new \InvalidArgumentException('non-nullable error cannot be null');
        }
        $allowedValues = $this->getErrorAllowableValues();
        if (!in_array($error, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'error', must be one of '%s'",
                    $error,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['error'] = $error;

        return $this;
    }

    /**
     * Gets message
     *
     * @return string
     */
    public function getMessage()
    {
        return $this->container['message'];
    }

    /**
     * Sets message
     *
     * @param string $message message
     *
     * @return self
     */
    public function setMessage($message)
    {
        if (is_null($message)) {
            throw new \InvalidArgumentException('non-nullable message cannot be null');
        }
        $this->container['message'] = $message;

        return $this;
    }

    /**
     * Gets path
     *
     * @return string
     */
    public function getPath()
    {
        return $this->container['path'];
    }

    /**
     * Sets path
     *
     * @param string $path path
     *
     * @return self
     */
    public function setPath($path)
    {
        if (is_null($path)) {
            throw new \InvalidArgumentException('non-nullable path cannot be null');
        }
        $this->container['path'] = $path;

        return $this;
    }

    /**
     * Gets details
     *
     * @return array<string,mixed>|null
     */
    public function getDetails()
    {
        return $this->container['details'];
    }

    /**
     * Sets details
     *
     * @param array<string,mixed>|null $details Optional additional information about the error that occurred
     *
     * @return self
     */
    public function setDetails($details)
    {
        if (is_null($details)) {
            throw new \InvalidArgumentException('non-nullable details cannot be null');
        }
        $this->container['details'] = $details;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


