<?php
/**
 * ActionUpdateRequest
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  cnb\api
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * CallNowButton API
 *
 * API for CallNowButton. Includes auth, domains, buttons/actions/conditions, but also chat and admin features.
 *
 * The version of the OpenAPI document: 0.0.219-local
 * Contact: support@nowbuttons.com
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.12.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace cnb\api\Model;

use \ArrayAccess;
use \cnb\api\ObjectSerializer;

/**
 * ActionUpdateRequest Class Doc Comment
 *
 * @category Class
 * @package  cnb\api
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class ActionUpdateRequest implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ActionUpdateRequest';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'id' => 'string',
        'action_type' => 'string',
        'action_value' => 'string',
        'properties' => 'array<string,string>',
        'background_color' => 'string',
        'icon_enabled' => 'bool',
        'icon_class' => 'string',
        'icon_color' => 'string',
        'icon_text' => 'string',
        'icon_type' => 'string',
        'icon_background_image' => 'string',
        'label_background_color' => 'string',
        'label_text' => 'string',
        'schedule' => '\cnb\api\Model\ActionSchedule'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'id' => null,
        'action_type' => null,
        'action_value' => null,
        'properties' => null,
        'background_color' => null,
        'icon_enabled' => null,
        'icon_class' => null,
        'icon_color' => null,
        'icon_text' => null,
        'icon_type' => null,
        'icon_background_image' => null,
        'label_background_color' => null,
        'label_text' => null,
        'schedule' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'id' => false,
        'action_type' => false,
        'action_value' => false,
        'properties' => false,
        'background_color' => false,
        'icon_enabled' => false,
        'icon_class' => false,
        'icon_color' => false,
        'icon_text' => false,
        'icon_type' => false,
        'icon_background_image' => false,
        'label_background_color' => false,
        'label_text' => false,
        'schedule' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        'action_type' => 'actionType',
        'action_value' => 'actionValue',
        'properties' => 'properties',
        'background_color' => 'backgroundColor',
        'icon_enabled' => 'iconEnabled',
        'icon_class' => 'iconClass',
        'icon_color' => 'iconColor',
        'icon_text' => 'iconText',
        'icon_type' => 'iconType',
        'icon_background_image' => 'iconBackgroundImage',
        'label_background_color' => 'labelBackgroundColor',
        'label_text' => 'labelText',
        'schedule' => 'schedule'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'action_type' => 'setActionType',
        'action_value' => 'setActionValue',
        'properties' => 'setProperties',
        'background_color' => 'setBackgroundColor',
        'icon_enabled' => 'setIconEnabled',
        'icon_class' => 'setIconClass',
        'icon_color' => 'setIconColor',
        'icon_text' => 'setIconText',
        'icon_type' => 'setIconType',
        'icon_background_image' => 'setIconBackgroundImage',
        'label_background_color' => 'setLabelBackgroundColor',
        'label_text' => 'setLabelText',
        'schedule' => 'setSchedule'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'action_type' => 'getActionType',
        'action_value' => 'getActionValue',
        'properties' => 'getProperties',
        'background_color' => 'getBackgroundColor',
        'icon_enabled' => 'getIconEnabled',
        'icon_class' => 'getIconClass',
        'icon_color' => 'getIconColor',
        'icon_text' => 'getIconText',
        'icon_type' => 'getIconType',
        'icon_background_image' => 'getIconBackgroundImage',
        'label_background_color' => 'getLabelBackgroundColor',
        'label_text' => 'getLabelText',
        'schedule' => 'getSchedule'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const ACTION_TYPE_ANCHOR = 'ANCHOR';
    public const ACTION_TYPE_EMAIL = 'EMAIL';
    public const ACTION_TYPE_HOURS = 'HOURS';
    public const ACTION_TYPE_LINK = 'LINK';
    public const ACTION_TYPE_MAP = 'MAP';
    public const ACTION_TYPE_PHONE = 'PHONE';
    public const ACTION_TYPE_SMS = 'SMS';
    public const ACTION_TYPE_WHATSAPP = 'WHATSAPP';
    public const ACTION_TYPE_FACEBOOK = 'FACEBOOK';
    public const ACTION_TYPE_SIGNAL = 'SIGNAL';
    public const ACTION_TYPE_TELEGRAM = 'TELEGRAM';
    public const ACTION_TYPE_IFRAME = 'IFRAME';
    public const ACTION_TYPE_TALLY = 'TALLY';
    public const ACTION_TYPE_INTERCOM = 'INTERCOM';
    public const ACTION_TYPE_SKYPE = 'SKYPE';
    public const ACTION_TYPE_ZALO = 'ZALO';
    public const ACTION_TYPE_VIBER = 'VIBER';
    public const ACTION_TYPE_LINE = 'LINE';
    public const ACTION_TYPE_WECHAT = 'WECHAT';
    public const ACTION_TYPE_CHAT = 'CHAT';
    public const ACTION_TYPE_BOOKING = 'BOOKING';
    public const ICON_TYPE__DEFAULT = 'DEFAULT';
    public const ICON_TYPE_CUSTOM = 'CUSTOM';
    public const ICON_TYPE_FONT = 'FONT';
    public const ICON_TYPE_SVG = 'SVG';
    public const ICON_TYPE_FONT_MATERIAL = 'FONT_MATERIAL';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getActionTypeAllowableValues()
    {
        return [
            self::ACTION_TYPE_ANCHOR,
            self::ACTION_TYPE_EMAIL,
            self::ACTION_TYPE_HOURS,
            self::ACTION_TYPE_LINK,
            self::ACTION_TYPE_MAP,
            self::ACTION_TYPE_PHONE,
            self::ACTION_TYPE_SMS,
            self::ACTION_TYPE_WHATSAPP,
            self::ACTION_TYPE_FACEBOOK,
            self::ACTION_TYPE_SIGNAL,
            self::ACTION_TYPE_TELEGRAM,
            self::ACTION_TYPE_IFRAME,
            self::ACTION_TYPE_TALLY,
            self::ACTION_TYPE_INTERCOM,
            self::ACTION_TYPE_SKYPE,
            self::ACTION_TYPE_ZALO,
            self::ACTION_TYPE_VIBER,
            self::ACTION_TYPE_LINE,
            self::ACTION_TYPE_WECHAT,
            self::ACTION_TYPE_CHAT,
            self::ACTION_TYPE_BOOKING,
        ];
    }

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getIconTypeAllowableValues()
    {
        return [
            self::ICON_TYPE__DEFAULT,
            self::ICON_TYPE_CUSTOM,
            self::ICON_TYPE_FONT,
            self::ICON_TYPE_SVG,
            self::ICON_TYPE_FONT_MATERIAL,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('id', $data ?? [], null);
        $this->setIfExists('action_type', $data ?? [], null);
        $this->setIfExists('action_value', $data ?? [], null);
        $this->setIfExists('properties', $data ?? [], null);
        $this->setIfExists('background_color', $data ?? [], null);
        $this->setIfExists('icon_enabled', $data ?? [], null);
        $this->setIfExists('icon_class', $data ?? [], null);
        $this->setIfExists('icon_color', $data ?? [], null);
        $this->setIfExists('icon_text', $data ?? [], null);
        $this->setIfExists('icon_type', $data ?? [], null);
        $this->setIfExists('icon_background_image', $data ?? [], null);
        $this->setIfExists('label_background_color', $data ?? [], null);
        $this->setIfExists('label_text', $data ?? [], null);
        $this->setIfExists('schedule', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['id'] === null) {
            $invalidProperties[] = "'id' can't be null";
        }
        if ($this->container['action_type'] === null) {
            $invalidProperties[] = "'action_type' can't be null";
        }
        $allowedValues = $this->getActionTypeAllowableValues();
        if (!is_null($this->container['action_type']) && !in_array($this->container['action_type'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'action_type', must be one of '%s'",
                $this->container['action_type'],
                implode("', '", $allowedValues)
            );
        }

        $allowedValues = $this->getIconTypeAllowableValues();
        if (!is_null($this->container['icon_type']) && !in_array($this->container['icon_type'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'icon_type', must be one of '%s'",
                $this->container['icon_type'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param string $id id
     *
     * @return self
     */
    public function setId($id)
    {
        if (is_null($id)) {
            throw new \InvalidArgumentException('non-nullable id cannot be null');
        }
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets action_type
     *
     * @return string
     */
    public function getActionType()
    {
        return $this->container['action_type'];
    }

    /**
     * Sets action_type
     *
     * @param string $action_type action_type
     *
     * @return self
     */
    public function setActionType($action_type)
    {
        if (is_null($action_type)) {
            throw new \InvalidArgumentException('non-nullable action_type cannot be null');
        }
        $allowedValues = $this->getActionTypeAllowableValues();
        if (!in_array($action_type, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'action_type', must be one of '%s'",
                    $action_type,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['action_type'] = $action_type;

        return $this;
    }

    /**
     * Gets action_value
     *
     * @return string|null
     */
    public function getActionValue()
    {
        return $this->container['action_value'];
    }

    /**
     * Sets action_value
     *
     * @param string|null $action_value action_value
     *
     * @return self
     */
    public function setActionValue($action_value)
    {
        if (is_null($action_value)) {
            throw new \InvalidArgumentException('non-nullable action_value cannot be null');
        }
        $this->container['action_value'] = $action_value;

        return $this;
    }

    /**
     * Gets properties
     *
     * @return array<string,string>|null
     */
    public function getProperties()
    {
        return $this->container['properties'];
    }

    /**
     * Sets properties
     *
     * @param array<string,string>|null $properties properties
     *
     * @return self
     */
    public function setProperties($properties)
    {
        if (is_null($properties)) {
            throw new \InvalidArgumentException('non-nullable properties cannot be null');
        }
        $this->container['properties'] = $properties;

        return $this;
    }

    /**
     * Gets background_color
     *
     * @return string|null
     */
    public function getBackgroundColor()
    {
        return $this->container['background_color'];
    }

    /**
     * Sets background_color
     *
     * @param string|null $background_color background_color
     *
     * @return self
     */
    public function setBackgroundColor($background_color)
    {
        if (is_null($background_color)) {
            throw new \InvalidArgumentException('non-nullable background_color cannot be null');
        }
        $this->container['background_color'] = $background_color;

        return $this;
    }

    /**
     * Gets icon_enabled
     *
     * @return bool|null
     */
    public function getIconEnabled()
    {
        return $this->container['icon_enabled'];
    }

    /**
     * Sets icon_enabled
     *
     * @param bool|null $icon_enabled icon_enabled
     *
     * @return self
     */
    public function setIconEnabled($icon_enabled)
    {
        if (is_null($icon_enabled)) {
            throw new \InvalidArgumentException('non-nullable icon_enabled cannot be null');
        }
        $this->container['icon_enabled'] = $icon_enabled;

        return $this;
    }

    /**
     * Gets icon_class
     *
     * @return string|null
     */
    public function getIconClass()
    {
        return $this->container['icon_class'];
    }

    /**
     * Sets icon_class
     *
     * @param string|null $icon_class icon_class
     *
     * @return self
     */
    public function setIconClass($icon_class)
    {
        if (is_null($icon_class)) {
            throw new \InvalidArgumentException('non-nullable icon_class cannot be null');
        }
        $this->container['icon_class'] = $icon_class;

        return $this;
    }

    /**
     * Gets icon_color
     *
     * @return string|null
     */
    public function getIconColor()
    {
        return $this->container['icon_color'];
    }

    /**
     * Sets icon_color
     *
     * @param string|null $icon_color icon_color
     *
     * @return self
     */
    public function setIconColor($icon_color)
    {
        if (is_null($icon_color)) {
            throw new \InvalidArgumentException('non-nullable icon_color cannot be null');
        }
        $this->container['icon_color'] = $icon_color;

        return $this;
    }

    /**
     * Gets icon_text
     *
     * @return string|null
     */
    public function getIconText()
    {
        return $this->container['icon_text'];
    }

    /**
     * Sets icon_text
     *
     * @param string|null $icon_text icon_text
     *
     * @return self
     */
    public function setIconText($icon_text)
    {
        if (is_null($icon_text)) {
            throw new \InvalidArgumentException('non-nullable icon_text cannot be null');
        }
        $this->container['icon_text'] = $icon_text;

        return $this;
    }

    /**
     * Gets icon_type
     *
     * @return string|null
     */
    public function getIconType()
    {
        return $this->container['icon_type'];
    }

    /**
     * Sets icon_type
     *
     * @param string|null $icon_type icon_type
     *
     * @return self
     */
    public function setIconType($icon_type)
    {
        if (is_null($icon_type)) {
            throw new \InvalidArgumentException('non-nullable icon_type cannot be null');
        }
        $allowedValues = $this->getIconTypeAllowableValues();
        if (!in_array($icon_type, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'icon_type', must be one of '%s'",
                    $icon_type,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['icon_type'] = $icon_type;

        return $this;
    }

    /**
     * Gets icon_background_image
     *
     * @return string|null
     */
    public function getIconBackgroundImage()
    {
        return $this->container['icon_background_image'];
    }

    /**
     * Sets icon_background_image
     *
     * @param string|null $icon_background_image icon_background_image
     *
     * @return self
     */
    public function setIconBackgroundImage($icon_background_image)
    {
        if (is_null($icon_background_image)) {
            throw new \InvalidArgumentException('non-nullable icon_background_image cannot be null');
        }
        $this->container['icon_background_image'] = $icon_background_image;

        return $this;
    }

    /**
     * Gets label_background_color
     *
     * @return string|null
     */
    public function getLabelBackgroundColor()
    {
        return $this->container['label_background_color'];
    }

    /**
     * Sets label_background_color
     *
     * @param string|null $label_background_color label_background_color
     *
     * @return self
     */
    public function setLabelBackgroundColor($label_background_color)
    {
        if (is_null($label_background_color)) {
            throw new \InvalidArgumentException('non-nullable label_background_color cannot be null');
        }
        $this->container['label_background_color'] = $label_background_color;

        return $this;
    }

    /**
     * Gets label_text
     *
     * @return string|null
     */
    public function getLabelText()
    {
        return $this->container['label_text'];
    }

    /**
     * Sets label_text
     *
     * @param string|null $label_text label_text
     *
     * @return self
     */
    public function setLabelText($label_text)
    {
        if (is_null($label_text)) {
            throw new \InvalidArgumentException('non-nullable label_text cannot be null');
        }
        $this->container['label_text'] = $label_text;

        return $this;
    }

    /**
     * Gets schedule
     *
     * @return \cnb\api\Model\ActionSchedule|null
     */
    public function getSchedule()
    {
        return $this->container['schedule'];
    }

    /**
     * Sets schedule
     *
     * @param \cnb\api\Model\ActionSchedule|null $schedule schedule
     *
     * @return self
     */
    public function setSchedule($schedule)
    {
        if (is_null($schedule)) {
            throw new \InvalidArgumentException('non-nullable schedule cannot be null');
        }
        $this->container['schedule'] = $schedule;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


